
/*

  Example written in LabWindows/CVI 5.5 in Windows 2000 SP1
  using KPCI-PDISO8A with ISO-850A01 DriverLINX version
  
  
  DriverLINX provides two API for programming digital I/O boards:
  1)  Service Request API for hardware independence
  2)  Direct I/O COM object for simple programming of Digital I/O boards
  
  Direct I/O requires that you know something of your hardware's
  register map.  See below.
  
  An ActiveX Automation wrapper was first built using menu structure of CVI
  Then load the resulting DirectIO.fp



*/


#include "DirectIO.h"
#include <cvirte.h>		
#include <userint.h>
#include "testDirectIO.h"

static int panelHandle;
static CAObjHandle myPIO;  // declare a variable for our object
							 
 int main (int argc, char *argv[])
{
	if (InitCVIRTE (0, argv, 0) == 0)
		return -1;	/* out of memory */
	if ((panelHandle = LoadPanel (0, "testDirectIO.uir", PANEL)) < 0)
		return -1;
	DisplayPanel (panelHandle);
	RunUserInterface ();
	DiscardPanel (panelHandle);
	return 0;
}

int CVICALLBACK Open (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	switch (event)
		{
		case EVENT_COMMIT:
 // instanciate the object		
 KDIGIOLib_NewIKDigitalIo (NULL, 1, LOCALE_NEUTRAL, 0, &myPIO);
 // open the driver for device 0 of the kpciiso driver
 KDIGIOLib_IKDigitalIoOpenDevice (myPIO, NULL, "kpciiso", 0);    
		break;
		}
	return 0;
}

int CVICALLBACK Exit (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	switch (event)
		{
		case EVENT_COMMIT:
KDIGIOLib_IKDigitalIoCloseDevice (myPIO, NULL); // close driver on exit
QuitUserInterface (0);							// tell CVI to close this application
			break;
		}
	return 0;
}


int CVICALLBACK Write (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	switch (event)
		{
		case EVENT_COMMIT:
// for KPCI-PIO32IOA, relays are at offset of 4 from the base
// value of 255 will close them all
 KDIGIOLib_IKDigitalIoWrite (myPIO, NULL, 4, 255);
			break;
		}
	return 0;
}

int CVICALLBACK OpenRelays (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	switch (event)
		{
		case EVENT_COMMIT:
// for KPCI-PIO32IOA, relays are at offset of 4 from the base
// value of 0 will open them all		
  KDIGIOLib_IKDigitalIoWrite (myPIO, NULL, 4, 0);
			break;
		}
	return 0;
}
